﻿using System;
using System.Collections;
using System.Windows;
using System.Windows.Data;

namespace WPF.PresentationLayer.Converters
{
    public class EmptyListToVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null) return Visibility.Collapsed;
            var list = value as ICollection;

            if (list == null) return Visibility.Collapsed;

            // *** Fortify Justified Code ***
            // *** can't be null since it is checked earler. ReSharper doesn't see an issues either ***
            return list.Count == 0 ? Visibility.Collapsed : Visibility.Visible;

            // *** Fortify Justified Code *** 

        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
